﻿//////////////////////////////////////////////
// DdsStandardCompressor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class ImageView ;

	struct AlignmentDescriptor ;
	struct ImageDescriptor ;
}

namespace nkImages::dds
{
	class DdsDxt10Header ;
	class DdsHeader ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::dds
{
	class DdsStandardCompressor final
	{
		public :

			// Compression
			static bool compress (const ImageView& input, nkMemory::BufferView<> output) ;

			// Decompression
			static unsigned int getAlignedDataFullSize (unsigned int pixelSize, bool compressedFormat, unsigned int arraySize, unsigned int width, unsigned int height, unsigned int depth, unsigned int mipCount, const AlignmentDescriptor& alignment) ;
			static nkMemory::Buffer decompress (const DdsHeader& header, const DdsDxt10Header* dxt10Header, nkMemory::BufferView<> dataView, nkMemory::BufferCast<ImageDescriptor>& images, const AlignmentDescriptor& alignmentDescriptor) ;
	} ;
}